Ext.data.JsonP.sol({"tagname":"class","name":"sol","autodetected":{},"files":[{"filename":"lib_Class.js","href":"lib_Class.html#sol"}],"singleton":true,"author":[{"tagname":"author","name":"Nils Mosbach, ELO Digital Office GmbH","email":null}],"eloall":true,"members":[{"name":"create","tagname":"method","owner":"sol","id":"static-method-create","meta":{"static":true}},{"name":"define","tagname":"method","owner":"sol","id":"static-method-define","meta":{"static":true}},{"name":"ns","tagname":"method","owner":"sol","id":"static-method-ns","meta":{"static":true}}],"alternateClassNames":[],"aliases":{},"id":"class-sol","short_doc":"Solutions are modularized using a js class framework that adapts concepts\nfrom object orientated languages. ...","classIcon":"icon-singleton","superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/lib_Class.html#sol' target='_blank'>lib_Class.js</a></div></pre><div class='doc-contents'><p>Solutions are modularized using a js class framework that adapts concepts\nfrom object orientated languages.</p>\n\n<h1>Modularization of solutions</h1>\n\n<p>Every function is implemented as a Class which allows passing configuration params to\nthe class on instantiation. Class definitions have been simplified\nthanks to a function called <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>. With the help of <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a> new class\ninstances can be created.</p>\n\n<p>For more information on modularization of classes refer to <a href=\"#!/api/sol.ClassManager\" rel=\"sol.ClassManager\" class=\"docClass\">sol.ClassManager</a>.</p>\n\n<h1>Namespaces</h1>\n\n<p>Modules are organized in namespaces. The creation of namespaces is explained in the class <a href=\"#!/api/sol.NamespaceManager\" rel=\"sol.NamespaceManager\" class=\"docClass\">sol.NamespaceManager</a>.\nPlease mind that the namespaces \"elo\" and \"sol\" are reserved by the ELO Digital Office GmbH.</p>\n\n<h1>Storing modules in ELO</h1>\n\n<p>JS files of the modules should be stored in ELO. It is recommended that namespaces are\nrepresented as structure elements from a logical view.</p>\n\n<p>e.g. the ix registered function \"RF_MyFunction\" which is part of the namespace \"sol.invoice.ix\" should be placed in...</p>\n\n<pre><code>[ELO Archive]\n  - Administration\n     - Business Solutions\n        - Common\n           [File] sol.common.Helpers.js\n        - Invoice\n           - IX Scripting Base\n              [File] sol.invoice.ix.RF_MyFunction\n\n     - IX Scripting Base\n        [Reference] sol.invoice.ix.RF_MyFunction\n        [Reference] sol.common.Helpers.js\n</code></pre>\n\n<p>If further files need to be imported within RF_MyFunction they should stay in the same hierarchy.\nScripts that should be used across IX, AS and WF must have an .js extension in their short description.</p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-create' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol'>sol</span><br/><a href='source/lib_Class.html#sol-static-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol-static-method-create' class='name expandable'>create</a>( <span class='pre'>className, config</span> ) : Object<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>Creates a new instance of a previously defined class. ...</div><div class='long'><p>Creates a new instance of a previously defined class.\nNew classes should always be created using <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>.</p>\n\n<pre><code>var log = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('sol.common.Logger', {\n  scope: 'sol.test'\n});\n</code></pre>\n\n<p>If no config object is passed an empty object will be used.</p>\n\n<p>Please refer to <a href=\"#!/api/sol.ClassManager\" rel=\"sol.ClassManager\" class=\"docClass\">sol.ClassManager</a> for more information on how classes can be created.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>configuration for the initialization function.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>created class instance.</p>\n</div></li></ul></div></div></div><div id='static-method-define' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol'>sol</span><br/><a href='source/lib_Class.html#sol-static-method-define' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol-static-method-define' class='name expandable'>define</a>( <span class='pre'>className, classDefinition</span> ) : null<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>Defines a new class. ...</div><div class='long'><p>Defines a new class.\nNew classes should always be defined using <a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>('sol.common.Logger', {\n  extend: 'sol.common.BaseClass',\n  mixins: ['sol.mixins.Configuration'],\n  singleton: false,\n\n    scope: 'sol',\n\n  initialize: function(config) {\n    var me = this;\n    me.scope = config.scope || me.scope;\n  },\n\n  debug: function (txt) {\n    var me = this;\n    console.log(me.scope + 'debug from logger class: '+ txt);\n  }\n});\n</code></pre>\n\n<p>Please refer to <a href=\"#!/api/sol.ClassManager\" rel=\"sol.ClassManager\" class=\"docClass\">sol.ClassManager</a> for more information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'><p>name of the class including its namespace.</p>\n</div></li><li><span class='pre'>classDefinition</span> : Object<div class='sub-desc'><p>class definition.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>null</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-ns' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol'>sol</span><br/><a href='source/lib_Class.html#sol-static-method-ns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol-static-method-ns' class='name expandable'>ns</a>( <span class='pre'>namespace</span> ) : Object<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>Creates a new namespace thanks to a given string. ...</div><div class='long'><p>Creates a new namespace thanks to a given string.\nNew namespace should always be created usind <a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-ns\" rel=\"sol-static-method-ns\" class=\"docClass\">sol.ns</a>('sol.common');\n</code></pre>\n\n<p>Please refer to <a href=\"#!/api/sol.NamespaceManager\" rel=\"sol.NamespaceManager\" class=\"docClass\">sol.NamespaceManager</a> for more information.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace</span> : String<div class='sub-desc'><p>namespace as string.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>returns the last instance of the created namespace object.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true,"singleton":true}});